#ifndef Shield_h
#define Shield_h

#define CMD_IRTX    0x01
#define CMD_IRRX    0x03
#define CMD_SPK     0x04
#define CMD_BLT     0x10
#define CMD_MPU     0x20
#define CMD_LED     0x40
#define CMD_SET     0x80

#include "Arduino.h"
#include "SPI.h"

class RX231_Shield {
  public:
    void begin();
    void end();
    void sendData(uint8_t cmd, const uint8_t * data_buf);
    uint8_t * receiveData();
    void setLed(uint8_t TS15, uint8_t TS16, uint8_t TS22, uint8_t TS23, uint8_t TS27, uint8_t TS30);
    void requestBLT(uint8_t data);
    void requestSPK(uint16_t hz, uint16_t ms);
    void requestMPU();
    void requestIR(uint8_t customData, uint8_t data) ;
    
    byte receiving(byte txData);
    
    
};

#endif
